/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package cache;

import java.util.Properties;

import com.inet.report.*;
import com.inet.report.cache.Cache;

/**
 * This sample shows how to manipulate reports put in Cache automatically with an implementation of class
 * PropertiesChecker. The sample set a default export format only. More relevant for exercise and possible is setting
 * PromptField values or Database Connection configuration.
 */
public class CacheAPIUsingPropertiesChecker {

    /**
     * Main method of the sample.
     * @param args no parameters used
     * @throws ReportException if an error occurred
     */
    public static void main( String[] args ) throws ReportException {
        Cache cache = Cache.getCache();
        //create the properties for the report 
        Properties reportProps = new Properties();
        reportProps.put( "report", "samples/sample.rpt" );
        //the report will be executed to pdf format, because the SamplePropertiesChecker set the property "export_fmt" = "pdf"
        cache.getKey( reportProps, new SamplePropertiesChecker(), null );
        // Stop Listener
        System.exit( 0 );
    }

    /**
     * The SampleProperiesChecker checks the value of the property "export_fmt" and set it per default to "pdf" format.
     * In the Properties object all properties can be set that also can be set in the report URL for the report server.
     * The complete list of possible properties can be found at:
     * https://docs.inetsoftware.de/reporting/help/report-url-parameters
     */
    static class SamplePropertiesChecker implements PropertiesChecker {

        /**
         * CheckProperties method used to set the export format to PDF if no format set.
         * @param props The user properties.
         * @param req The HTTP servlet request, either null or HttpServlet
         * @throws ReportException if an error occurred
         */
        @Override
        public void checkProperties( Properties props, Object req ) throws ReportException {
            if( !props.containsKey( "export_fmt" ) ) {
                props.put( "export_fmt", "pdf" );
            }
        }

        /**
         * Unused checkProperties method of the PropertiesChecker
         * @param engine The initialized engine that have parsed the rpt file already.
         * @param immutableProperties The user properties.
         * @param req The HTTP servlet request, either null or HttpServlet
         * @throws ReportException if an error occurred
         */
        @Override
        public void checkProperties( Engine engine, Properties immutableProperties, Object req ) throws ReportException {

        }
    }
}
